package ru.yandex.webmaster3.api.http.rest;

import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;

/**
 * @author avhaliullin
 */
public abstract class AbstractApiAction<Request extends ApiRequest<?>, Response extends ApiResponse> {
    private final Permission permission;

    protected AbstractApiAction() {
        this(null);
    }

    protected AbstractApiAction(Permission permission) {
        this.permission = permission;
    }

    public abstract Response process(Request request);

    public Permission getPermission() {
        return permission;
    }
}
