package ru.yandex.webmaster3.api.http.rest.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class WebmasterApiAnnotationIntrospector extends AnnotationIntrospector {
    @Override
    public String findPropertyDescription(Annotated ann) {
        Description description = _findAnnotation(ann, Description.class);
        return description == null ? null : description.value();
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember m) {
        return !m.getType().getRawClass().equals(Optional.class);
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }
}
