package ru.yandex.webmaster3.api.http.rest.jackson.deser;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import ru.yandex.webmaster3.core.searchquery.QueryId;

import java.io.IOException;
import java.util.Optional;

/**
 * @author avhaliullin
 */
public class ApiQueryIdDeserializer extends FromStringDeserializer<QueryId> {

    public ApiQueryIdDeserializer() {
        super(QueryId.class);
    }

    @Override
    protected QueryId _deserialize(String value, DeserializationContext ctxt) throws IOException {
        Optional<QueryId> resOpt = QueryId.fromStringId(value);
        if (resOpt.isPresent()) {
            return resOpt.get();
        } else {
            throw ctxt.mappingException("Invalid query id: \"%s\"", value);
        }
    }
}
