package ru.yandex.webmaster3.api.http.rest.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.api.sitemap.util.SitemapIdUtil;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public class ApiSitemapIdSerializer extends StdSerializer<ApiSitemapId> {
    public ApiSitemapIdSerializer() {
        super(ApiSitemapId.class);
    }

    @Override
    public void serialize(ApiSitemapId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(SitemapIdUtil.toString(value));
    }
}
