package ru.yandex.webmaster3.api.http.rest.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.eclipse.jetty.server.Request;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public abstract class RequestAwareSerializer<T> extends StdSerializer<T> {
    private final ThreadLocal<Request> request;

    public RequestAwareSerializer(Class<T> t, ThreadLocal<Request> request) {
        super(t);
        this.request = request;
    }

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        serialize(value, gen, provider, request.get());
    }

    public abstract void serialize(T value, JsonGenerator gen, SerializerProvider provider, Request request) throws IOException;

}
