package ru.yandex.webmaster3.api.http.rest.jackson.xml;

import com.fasterxml.jackson.databind.util.NameTransformer;

/**
 * @author avhaliullin
 */
public class PluralNameTransformer extends NameTransformer {
    @Override
    public String transform(String name) {
        if (name.endsWith("ies")) {
            return name.substring(0, name.length() - "ies".length()) + "y";
        } else if (name.endsWith("s")) {
            return name.substring(0, name.length() - 1);
        } else {
            return name;
        }
    }

    @Override
    public String reverse(String transformed) {
        return null;
    }

    public static final PluralNameTransformer INSTANCE = new PluralNameTransformer();
}
