package ru.yandex.webmaster3.api.http.rest.jackson.xml;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;

import java.util.List;

/**
 * @author avhaliullin
 */
public class XmlPluralDeserializerModifier extends BeanDeserializerModifier {
    @Override
    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        for (int i = 0; i < propDefs.size(); i++) {
            BeanPropertyDefinition propertyDefinition = propDefs.get(i);
            JavaType propType = propertyDefinition.getMutator().getType(beanDesc.bindingsForBeanType());
            if (TypeUtil.isIndexedType(propType) && propertyDefinition.getName().endsWith("s")) {
                propDefs.set(i, propertyDefinition.withSimpleName(PluralNameTransformer.INSTANCE.transform(propertyDefinition.getName())));
            }
        }
        return propDefs;
    }


}
