package ru.yandex.webmaster3.api.http.rest.jackson.xml;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;

import java.util.List;

/**
 * @author avhaliullin
 */
public class XmlPluralSerializedModifier extends BeanSerializerModifier {
    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (int i = 0, len = beanProperties.size(); i < len; ++i) {
            BeanPropertyWriter propertyWriter = beanProperties.get(i);
            if (TypeUtil.isIndexedType(propertyWriter.getType())) {
                if (propertyWriter.getName().endsWith("s")) {
                    beanProperties.set(i, propertyWriter.rename(PluralNameTransformer.INSTANCE));
                }
            }
        }
        return beanProperties;
    }
}
