package ru.yandex.webmaster3.api.http.rest.request;

import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ParamFilters {
    private final Map<AbstractApiAction, Map<String, List<ApiRequestParameterFilter>>> filters;

    public ParamFilters(Map<AbstractApiAction, Map<String, List<ApiRequestParameterFilter>>> filters) {
        this.filters = filters;
    }

    public List<ApiRequestParameterFilter> getFilters(AbstractApiAction action, String paramName) {
        Map<String, List<ApiRequestParameterFilter>> name2Filters = filters.get(action);
        if (name2Filters == null) {
            return Collections.emptyList();
        }
        List<ApiRequestParameterFilter> result = name2Filters.get(paramName);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }
}
