package ru.yandex.webmaster3.api.http.rest.response;

/**
 * Эта магия позволяет узнавать код ответа через reflection без инстанцирования объекта response
 *
 * @author avhaliullin
 */
public interface HttpStatus {
    int getCode();

    String getDescription();

    abstract class AbstractStatus implements HttpStatus {
        private final int code;
        private final String description;

        private AbstractStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        @Override
        public int getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }
    }

    // 2xx
    class Http200 extends AbstractStatus {
        private Http200() {
            super(200, "Success");
        }
    }

    class Http201 extends AbstractStatus {
        private Http201() {
            super(201, "Created");
        }
    }

    class Http202 extends AbstractStatus {
        private Http202() {
            super(202, "Accepted");
        }
    }

    class Http204 extends AbstractStatus {
        private Http204() {
            super(204, "No Content");
        }
    }

    Http200 HTTP_200 = new Http200();
    Http201 HTTP_201 = new Http201();
    Http202 HTTP_202 = new Http202();
    Http204 HTTP_204 = new Http204();

    // 4xx
    class Http400 extends AbstractStatus {
        private Http400() {
            super(400, "Bad Request");
        }
    }

    class Http401 extends AbstractStatus {
        private Http401() {
            super(401, "Unauthorized");
        }
    }

    class Http403 extends AbstractStatus {
        private Http403() {
            super(403, "Forbidden");
        }
    }

    class Http404 extends AbstractStatus {
        private Http404() {
            super(404, "Not Found");
        }
    }

    class Http405 extends AbstractStatus {
        private Http405() {
            super(405, "Method Not Allowed");
        }
    }

    class Http406 extends AbstractStatus {
        private Http406() {
            super(406, "Not Acceptable");
        }
    }

    class Http409 extends AbstractStatus {
        private Http409() {
            super(409, "Conflict");
        }
    }

    class Http410 extends AbstractStatus {
        private Http410() {
            super(410, "Gone");
        }
    }

    class Http413 extends AbstractStatus {
        private Http413() {
            super(413, "Payload Too Large");
        }
    }

    class Http415 extends AbstractStatus {
        private Http415() {
            super(415, "Unsupported Media Type");
        }
    }

    class Http422 extends AbstractStatus {
        private Http422() {
            super(422, "Unprocessable Entity");
        }
    }

    class Http429 extends AbstractStatus {
        private Http429() {
            super(429, "Too Many Requests");
        }
    }

    Http400 HTTP_400 = new Http400();
    Http401 HTTP_401 = new Http401();
    Http403 HTTP_403 = new Http403();
    Http404 HTTP_404 = new Http404();
    Http405 HTTP_405 = new Http405();
    Http406 HTTP_406 = new Http406();
    Http409 HTTP_409 = new Http409();
    Http410 HTTP_410 = new Http410();
    Http413 HTTP_413 = new Http413();
    Http415 HTTP_415 = new Http415();
    Http422 HTTP_422 = new Http422();
    Http429 HTTP_429 = new Http429();

    // 5xx
    class Http500 extends AbstractStatus {
        private Http500() {
            super(500, "Internal Server Error");
        }
    }

    Http500 HTTP_500 = new Http500();
}
