package ru.yandex.webmaster3.api.http.rest.response.errors;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;

/**
 * @author avhaliullin
 */
public interface ApiErrorResponse<C extends Enum<C> & ApiErrorCode> extends ApiResponse {
    @Description("Error code")
    C getErrorCode();

    @Description("Error message")
    String getErrorMessage();

    abstract class AbstractErrorResponse<C extends Enum<C> & ApiErrorCode> implements ApiErrorResponse<C> {
        private final C code;
        private final String message;

        public AbstractErrorResponse(C code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public C getErrorCode() {
            return code;
        }

        @Override
        public String getErrorMessage() {
            return message;
        }
    }
}
