package ru.yandex.webmaster3.api.http.rest.routing;

import java.util.function.Function;

/**
 * @author avhaliullin
 */
public abstract class PathPart<L> {
    public abstract String fromLocator(L locator);

    public abstract boolean isStatic();

    public static class Const<T> extends PathPart<T> {
        private final String segment;

        public Const(String segment) {
            this.segment = segment;
        }

        @Override
        public String fromLocator(T locator) {
            return segment;
        }

        public String getSegment() {
            return segment;
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    }

    public static class Param<T, P> extends PathPart<T> {
        private final UrlParam<P> param;
        private final String name;
        private final Function<T, P> locator2PathMapper;
        private final String description;

        public Param(UrlParam<P> param, String name, Function<T, P> locator2PathMapper, String description) {
            this.param = param;
            this.name = name;
            this.locator2PathMapper = locator2PathMapper;
            this.description = description;
        }

        @Override
        public String fromLocator(T locator) {
            return param.rightToLeft(locator2PathMapper.apply(locator));
        }

        public UrlParam<P> getParam() {
            return param;
        }

        public String getName() {
            return name;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        public String getDescription() {
            return description;
        }
    }
}
