package ru.yandex.webmaster3.api.http.rest.routing;

import java.util.Optional;
import java.util.function.Function;

/**
 * @author avhaliullin
 */
public class QueryParam<L, P> {
    private final String name;
    private final UrlParam<P> param;
    private final Function<L, Optional<P>> locator2Param;
    private final String description;
    private final boolean required;

    public QueryParam(String name, UrlParam<P> param, Function<L, Optional<P>> locator2Param, String description, boolean required) {
        this.name = name;
        this.param = param;
        this.locator2Param = locator2Param;
        this.description = description;
        this.required = required;
    }

    public String getName() {
        return name;
    }

    public UrlParam<P> getParam() {
        return param;
    }

    public String getDescription() {
        return description;
    }

    public Optional<String> valueFromLocator(L locator) {
        return locator2Param.apply(locator).map(param::rightToLeft);
    }

    public boolean isRequired() {
        return required;
    }
}
