package ru.yandex.webmaster3.api.http.rest.routing;

import ru.yandex.webmaster3.core.util.URLEncodeUtil;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class QueryString {
    private final List<String> pathSegments;
    private final Map<String, List<String>> queryParams;

    public QueryString(List<String> pathSegments, Map<String, List<String>> queryParams) {
        this.pathSegments = pathSegments;
        this.queryParams = queryParams;
    }

    public List<String> getPathSegments() {
        return pathSegments;
    }

    public Map<String, List<String>> getQueryParams() {
        return queryParams;
    }

    public String getPathString() {
        return "/" + String.join("/", pathSegments) + "/";
    }

    public String getQueryString() {
        if (queryParams.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String delim = "?";
        for (Map.Entry<String, List<String>> entry : queryParams.entrySet()) {
            for (String value : entry.getValue()) {
                sb.append(delim);
                delim = "&";

                sb.append(entry.getKey())
                        .append("=")
                        .append(URLEncodeUtil.urlEncode(value));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return getPathString() + getQueryString();
    }
}
