package ru.yandex.webmaster3.api.http.rest.routing;

/**
 * @author avhaliullin
 */
public class QueryStringParseException extends RuntimeException {
    private final String paramName;
    private final boolean pathParam;
    private final String passedValue;

    QueryStringParseException(Throwable cause, String paramName, boolean pathParam, String passedValue) {
        super(cause);
        this.paramName = paramName;
        this.pathParam = pathParam;
        this.passedValue = passedValue;
    }

    public String getParamName() {
        return paramName;
    }

    public String getPassedValue() {
        return passedValue;
    }

    public boolean isPathParam() {
        return pathParam;
    }

    public static class MissingRequiredParamException extends QueryStringParseException {
        public MissingRequiredParamException(String paramName, boolean pathParam) {
            super(null, paramName, pathParam, null);
        }
    }

    public static class ValidationException extends QueryStringParseException {
        public ValidationException(Throwable cause, String paramName, boolean pathParam, String passedValue) {
            super(cause, paramName, pathParam, passedValue);
        }
    }
}
