package ru.yandex.webmaster3.api.http.rest.routing;

import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.util.functional.Bijection;

import java.util.List;
import java.util.Map;

public class Resource<T> {
    private final Class<T> locatorClass;
    private final Map<String, AbstractApiAction> method2Action;
    private final List<PathPart<T>> path;
    private final List<QueryParam<T, ?>> query;
    private final Bijection<QueryString, T> locatorMapping;

    public Resource(Class<T> locatorClass, Map<String, AbstractApiAction> method2Action, List<PathPart<T>> path,
                    List<QueryParam<T, ?>> query, Bijection<QueryString, T> locatorMapping) {
        this.locatorClass = locatorClass;
        this.method2Action = method2Action;
        this.path = path;
        this.query = query;
        this.locatorMapping = locatorMapping;
    }

    public Class<T> getLocatorClass() {
        return locatorClass;
    }

    public Map<String, AbstractApiAction> getMethod2Action() {
        return method2Action;
    }

    public List<PathPart<T>> getPath() {
        return path;
    }

    public List<QueryParam<T, ?>> getQuery() {
        return query;
    }

    public Bijection<QueryString, T> getLocatorMapping() {
        return locatorMapping;
    }
}
