package ru.yandex.webmaster3.api.http.rest.routing;

import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.response.ApiDeleteResponse;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.ApiPostResponse;
import ru.yandex.webmaster3.core.util.functional.Bijection;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ResourceBuilder<L> {
    final Class<L> locatorClass;
    final Bijection<QueryString, L> locatorMapping;
    final List<PathPart<L>> path;
    final List<QueryParam<L, ?>> query;
    AbstractApiAction<?, ?> onGet;
    AbstractApiAction<?, ?> onPost;
    AbstractApiAction<?, ?> onDelete;

    public ResourceBuilder(Class<L> locatorClass, Bijection<QueryString, L> locatorMapping, List<PathPart<L>> path, List<QueryParam<L, ?>> query) {
        this.locatorClass = locatorClass;
        this.locatorMapping = locatorMapping;
        this.path = path;
        this.query = query;
    }

    public <Req extends ApiRequest<L>, Res extends ApiGetResponse> ResourceBuilder<L> onGet(AbstractApiAction<Req, Res> action) {
        this.onGet = action;
        return this;
    }

    public <Req extends ApiRequest<L>, Res extends ApiPostResponse> ResourceBuilder<L> onPost(AbstractApiAction<Req, Res> action) {
        this.onPost = action;
        return this;
    }

    public <Req extends ApiRequest<L>, Res extends ApiDeleteResponse> ResourceBuilder<L> onDelete(AbstractApiAction<Req, Res> action) {
        this.onDelete = action;
        return this;
    }
}
