package ru.yandex.webmaster3.api.http.rest.types;

import ru.yandex.autodoc.common.doc.DocUtils;
import ru.yandex.autodoc.common.doc.types.EnumType;
import ru.yandex.autodoc.common.doc.types.ValueType;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class WebmasterApiTypes {
    public static ValueType CHAR = new ValueType.Primitive("single char", ValueType.SINGLE, "C");

    public static ValueType DATE_TIME = new ValueType.Primitive("yyyy-MM-ddTHH:mm:ss,sssZ", ValueType.STRING, "2016-01-01T00:00:00,000+0300");
    public static ValueType DATE = new ValueType.Primitive("yyyy-MM-dd", ValueType.STRING, "2016-01-01");
    public static ValueType TIMESTAMP_MS = new ValueType.Primitive("unix timestamp ms", ValueType.INT64, "1451606400000");

    public static ValueType URL = new ValueType.Primitive("URL", ValueType.STRING, "http://example.com/some/path?a=b");

    public static ValueType UUID = new ValueType.Primitive("UUID", ValueType.STRING, "c7fe80c0-36e3-11e6-8b2d-df96aa592c0a");

    public static ValueType HOST_ID = new ValueType.Primitive("host id", ValueType.STRING, "http:ya.ru:80");
    public static ValueType HOST_ASCII_URL = new ValueType.Primitive("host ASCII url", ValueType.STRING, "http://xn--d1acpjx3f.xn--p1ai/");
    public static ValueType HOST_UNICODE_URL = new ValueType.Primitive("host unicode url", ValueType.STRING, "http://яндекс.рф/");

    public static ValueType SITEMAP_ID = new ValueType.Primitive("sitemap id", ValueType.STRING, "c7-fe:80-c0");
    public static ValueType QUERY_ID = new ValueType.Primitive("query id", ValueType.STRING, "a08b");

    public static ValueType enumType(Class<? extends Enum<?>> clazz) {
        List<EnumType.Entry> entries = new ArrayList<>();
        for (Enum<?> value : clazz.getEnumConstants()) {
            String name = value.name();
            String desc = null;
            try {
                desc = DocUtils.getDescriptionForAnnotatedElement(clazz.getField(value.name()));
            } catch (NoSuchFieldException e) {
                //ignore
            }
            entries.add(new EnumType.Entry(name, desc));
        }
        return new EnumType(clazz.getSimpleName(), entries);
    }
}
