package ru.yandex.webmaster3.api.http.util;

import ru.yandex.webmaster3.api.host.filter.trait.ApiHostIdAwareRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventId;

/**
 * @author avhaliullin
 */
public class ApiEventUtil {
    public static <T extends ApiRequest<?> & ApiHostIdAwareRequest> HostEvent create(T req, HostEventData data) {
        return HostEvent.create(
                HostEventId.createFromUserRequest(
                        req.getBalancerRequestId(),
                        req.getAuthorizedUserId()
                ),
                req.getHostId(),
                data
        );
    }
}
