package ru.yandex.webmaster3.api.http.util;

import ru.yandex.webmaster3.api.http.auth.ApiRequestAuthorizer;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestFilter;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestParameterFilter;
import ru.yandex.webmaster3.api.http.rest.response.HttpStatus;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;
import ru.yandex.webmaster3.core.http.autodoc.FullTypeInfo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ApiReflectionUtil {
    public static final Map<Class, HttpStatus> STATUSES_MAP;

    static {
        STATUSES_MAP = new HashMap<>();
        Class<HttpStatus> httpStatusClass = HttpStatus.class;
        for (Field field : httpStatusClass.getDeclaredFields()) {
            Class<?> fieldType = field.getType();
            if (httpStatusClass.isAssignableFrom(fieldType)) {
                try {
                    STATUSES_MAP.put(fieldType, (HttpStatus) field.get(null));
                } catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to access field " + httpStatusClass.toString() + "." + field.getName());
                }
            }
        }
    }

    public static FullTypeInfo getActionRequestType(AbstractApiAction action) {
        return FullTypeInfo.createSimple(action.getClass()).ancestorFullType(AbstractApiAction.class).getGenericsList().get(0);
    }

    public static FullTypeInfo getActionResponseType(AbstractApiAction action) {
        return FullTypeInfo.createSimple(action.getClass()).ancestorFullType(AbstractApiAction.class).getGenericsList().get(1);
    }

    public static FullTypeInfo getRequestFilterResponseType(ApiRequestFilter filter) {
        return FullTypeInfo.createSimple(filter.getClass()).ancestorFullType(ApiRequestFilter.class).getGenericsList().get(1);
    }

    public static FullTypeInfo getRequestFilterRequestType(ApiRequestFilter filter) {
        return FullTypeInfo.createSimple(filter.getClass()).ancestorFullType(ApiRequestFilter.class).getGenericsList().get(0);
    }

    public static FullTypeInfo getErrorResponseCodesClass(Class errorResponseClass) {
        return FullTypeInfo.createSimple(errorResponseClass).ancestorFullType(ApiErrorResponse.class).getGenericsList().get(0);
    }

    public static FullTypeInfo getAuthorizerResponseClass(ApiRequestAuthorizer authorizer) {
        return FullTypeInfo.createSimple(authorizer.getClass()).ancestorFullType(ApiRequestAuthorizer.class).getGenericsList().get(0);
    }

    public static FullTypeInfo getRequestParameterFilterType(Class filterClass) {
        return FullTypeInfo.createSimple(filterClass).ancestorFullType(ApiRequestParameterFilter.class).getGenericsList().get(0);
    }

    public static HttpStatus getResponseStatus(Class responseClass) {
        try {
            Method method = responseClass.getMethod("getStatus");
            Class statusType = method.getReturnType();
            HttpStatus result = STATUSES_MAP.get(statusType);
            if (result == null) {
                throw new RuntimeException("Unknown http status class " + statusType + " of getStatus method of class " + responseClass + ". Did you forget to provide specific HttpStatus type in ApiResponse.getStatus() for " + responseClass.getName() + "?");
            }
            return result;
        } catch (NoSuchMethodException e) {
            throw new RuntimeException("Not found getStatus method for class " + responseClass + ". Is it ApiResponse class?");
        }
    }
}
