package ru.yandex.webmaster3.api.importanturls.action;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.importanturls.data.ApiImportantUrl;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.importanturls.ImportantUrlsService;

/**
 * @author leonidrom
 */
@Category("importanturls")
@Component
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@ActionPermission(Permission.COMMON)
public class ImportantUrlHistoryAction extends AbstractApiAction<ImportantUrlHistoryRequest, ImportantUrlHistoryResponse> {

    private final ImportantUrlsService importantUrlsService;

    @Override
    public ImportantUrlHistoryResponse process(ImportantUrlHistoryRequest request) {
        String relativeUrl = null;
        WebmasterHostId hostId = request.getHostId();
        try {
            relativeUrl = IdUtils.toRelativeUrl(hostId, request.getUrl(), true);
        } catch (Exception e) {
            // обрабатываем ниже
        }

        if (relativeUrl == null) {
            return new ImportantUrlHistoryResponse.InvalidUrl();
        }

        String fullUrl = hostId.getPunycodeHostname() + relativeUrl;
        List<ApiImportantUrl> history =  importantUrlsService.getHistory(hostId, relativeUrl).stream()
                .map(s -> ApiImportantUrl.fromCoreImportantUrlStatus(fullUrl, s))
                .collect(Collectors.toList());

        return new ImportantUrlHistoryResponse.NormalResponse(history);
    }
}
