package ru.yandex.webmaster3.api.importanturls.action;

import lombok.RequiredArgsConstructor;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.importanturls.data.ApiImportantUrl;

import java.util.List;

/**
 * @author leonidrom
 */
public interface ImportantUrlHistoryResponse extends ApiGetResponse {
    @RequiredArgsConstructor
    class NormalResponse extends Success200 implements ImportantUrlHistoryResponse {
        private final List<ApiImportantUrl> history;

        @Description("История урла")
        public List<ApiImportantUrl> getHistory() {
            return history;
        }
    }

    enum Errors implements ApiErrorCode {
        INVALID_URL,
    }

    @Description("Неправильный URL")
    class InvalidUrl extends BadRequest400<Errors> implements ImportantUrlHistoryResponse {
        public InvalidUrl() {
            super(Errors.INVALID_URL, "Url is invalid or belongs to a different host");
        }
    }
}
