package ru.yandex.webmaster3.api.importanturls.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlStatus;

import java.util.ArrayList;
import java.util.List;

/**
 * @author leonidrom
 */
public enum ApiImportantUrlChangeIndicator {
    @Description("Изменение http кода при обходе страницы Роботом")
    INDEXING_HTTP_CODE,

    @Description("Изменение статуса страницы в Поиске")
    SEARCH_STATUS,

    @Description("Изменение заголовка страницы")
    TITLE,

    @Description("Изменение description")
    DESCRIPTION
    ;

    public static List<ApiImportantUrlChangeIndicator> fromCoreImportantUrlStatus(ImportantUrlStatus status) {
        List<ApiImportantUrlChangeIndicator> indicators = new ArrayList<>();

        if (status.isHttpCodeChanged()) {
            indicators.add(INDEXING_HTTP_CODE);
        }

        if (status.isSearchStatusChanged()) {
            indicators.add(SEARCH_STATUS);
        }

        if (status.isTitleChanged()) {
            indicators.add(TITLE);
        }

        if (status.isDescriptionChanged()) {
            indicators.add(DESCRIPTION);
        }

        return indicators;
    }
}
