package ru.yandex.webmaster3.api.indexing.action;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiDateRangeRequest;
import ru.yandex.webmaster3.api.indexing.IndexingHistoryLocator;
import ru.yandex.webmaster3.api.indexing.data.ApiIndexingIndicator;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.host.HostDataState;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class IndexingHistoryRequest extends AbstractApiUserVerifiedHostRequest<IndexingHistoryLocator>
        implements IndexedHostRequest, ApiDateRangeRequest {
    private HostDataState hostDataState;
    private Set<ApiIndexingIndicator> indexingIndicators;
    private DateTime dateFrom;
    private DateTime dateTo;

    public Set<ApiIndexingIndicator> getIndexingIndicators() {
        return indexingIndicators;
    }

    @Override
    public DateTime getDateFrom() {
        return dateFrom;
    }

    @Override
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public DateTime getDateTo() {
        return dateTo;
    }

    @Override
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    @Description("Список индикаторов, для которых нужно показать историю")
    @RequestQueryProperty(required = true)
    public void setIndexingIndicators(Set<ApiIndexingIndicator> indexingIndicators) {
        this.indexingIndicators = indexingIndicators;
    }

    @Override
    public HostDataState getHostDataState() {
        return hostDataState;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }
}
