package ru.yandex.webmaster3.api.indexing.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.indexing.data.ApiIndexingIndicator;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class IndexingHistoryResponse extends ApiResponse.Success200 {
    private final Map<ApiIndexingIndicator, List<ApiHistoryPoint<Long>>> indicators;

    public IndexingHistoryResponse(Map<ApiIndexingIndicator, List<ApiHistoryPoint<Long>>> indicators) {
        this.indicators = indicators;
    }

    @Description("Истории значений запрошенных индикаторов")
    public Map<ApiIndexingIndicator, List<ApiHistoryPoint<Long>>> getIndicators() {
        return indicators;
    }
}
