package ru.yandex.webmaster3.api.indexing.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.codes.DownloadedHttpCodeGroup;
import ru.yandex.webmaster3.core.codes.ErrorGroupEnum;
import ru.yandex.webmaster3.core.codes.ICodeGroup;

import java.util.function.IntPredicate;

/**
 * @author avhaliullin
 */
public enum ApiIndexingIndicator implements ICodeGroup {
    @Description("Страницы в поиске")
    SEARCHABLE,
    @Description("Загруженные страницы")
    DOWNLOADED(DownloadedHttpCodeGroup.values()),
    @Description("Загруженные с кодом из группы 2xx")
    DOWNLOADED_2XX(DownloadedHttpCodeGroup.DOWNLOADED_2XX),
    @Description("Загруженные с кодом из группы 3xx")
    DOWNLOADED_3XX(DownloadedHttpCodeGroup.DOWNLOADED_3XX),
    @Description("Загруженные с кодом из группы 4xx")
    DOWNLOADED_4XX((DownloadedHttpCodeGroup.DOWNLOADED_4XX)),
    @Description("Загруженные с кодом из группы 5xx")
    DOWNLOADED_5XX(DownloadedHttpCodeGroup.DOWNLOADED_5XX),
    @Description("Не удалось загрузить")
    FAILED_TO_DOWNLOAD(DOWNLOADED.predicate.negate()),
    @Description("Исключенные")
    EXCLUDED(ErrorGroupEnum.values()),
    @Description("Исключенные по желанию владельца ресурса (4xx-коды, запрет в robots.txt)")
    EXCLUDED_DISALLOWED_BY_USER(ErrorGroupEnum.DISALLOWED_BY_USER),
    @Description("Исключенные из-за ошибки на стороне сайта")
    EXCLUDED_SITE_ERROR(ErrorGroupEnum.SITE_ERROR),
    @Description("Исключенные из-за отсутствия поддержки на стороне роботов Яндекса")
    EXCLUDED_NOT_SUPPORTED(ErrorGroupEnum.UNSUPPORTED_BY_ROBOT),

    DOWNLOADED_200(200),
    DOWNLOADED_201(201),
    DOWNLOADED_202(202),
    DOWNLOADED_203(203),
    DOWNLOADED_204(204),
    DOWNLOADED_205(205),
    DOWNLOADED_206(206),
    DOWNLOADED_300(300),
    DOWNLOADED_301(301),
    DOWNLOADED_302(302),
    DOWNLOADED_303(303),
    DOWNLOADED_304(304),
    DOWNLOADED_305(305),
    DOWNLOADED_306(306),
    DOWNLOADED_307(307),
    DOWNLOADED_308(308),
    DOWNLOADED_400(400),
    DOWNLOADED_401(401),
    DOWNLOADED_402(402),
    DOWNLOADED_403(403),
    DOWNLOADED_404(404),
    DOWNLOADED_405(405),
    DOWNLOADED_406(406),
    DOWNLOADED_407(407),
    DOWNLOADED_408(408),
    DOWNLOADED_409(409),
    DOWNLOADED_410(410),
    DOWNLOADED_411(411),
    DOWNLOADED_412(412),
    DOWNLOADED_413(413),
    DOWNLOADED_414(414),
    DOWNLOADED_415(415),
    DOWNLOADED_416(416),
    DOWNLOADED_417(417),
    DOWNLOADED_418(418),
    DOWNLOADED_419(419),
    DOWNLOADED_426(426),
    DOWNLOADED_428(428),
    DOWNLOADED_429(429),
    DOWNLOADED_431(431),
    DOWNLOADED_500(500),
    DOWNLOADED_501(501),
    DOWNLOADED_502(502),
    DOWNLOADED_503(503),
    DOWNLOADED_504(504),
    DOWNLOADED_505(505),
    DOWNLOADED_506(506),
    DOWNLOADED_509(509),
    DOWNLOADED_510(510),
    DOWNLOADED_511(511),
    ;

    private final IntPredicate predicate;

    ApiIndexingIndicator(IntPredicate predicate) {
        this.predicate = predicate;
    }

    ApiIndexingIndicator(int exactCode) {
        this(code -> code == exactCode);
    }

    ApiIndexingIndicator(ICodeGroup... codeGroups) {
        this(code -> {
            for (ICodeGroup codeGroup : codeGroups) {
                if (codeGroup.contains(code)) {
                    return true;
                }
            }
            return false;
        });
    }

    public boolean contains(Integer code) {
        return code != null && predicate.test(code);
    }
}
