package ru.yandex.webmaster3.api.indexing2.action;


import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.indexing2.data.IndexingStatusEnum;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class Indexing2HistoryResponse extends ApiResponse.Success200 {
    private final Map<IndexingStatusEnum, List<ApiHistoryPoint<Long>>> indicators;

    public Indexing2HistoryResponse(Map<IndexingStatusEnum, List<ApiHistoryPoint<Long>>> indicators) {
        this.indicators = indicators;
    }

    @Description("История индексирования. Значения на графике - количество обойденных в этот день и с таким статусом страниц")
    public Map<IndexingStatusEnum, List<ApiHistoryPoint<Long>>> getIndicators() {
        return indicators;
    }
}
