package ru.yandex.webmaster3.api.indexing2.action;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.indexing2.data.ApiIndexedPageSample;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexingSamplesService;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexedUrlSamplesOrderField;
import ru.yandex.webmaster3.storage.indexing2.samples.data.IndexedUrlSample;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@Description("Посмотреть примеры последних загруженых страниц")
@Category("indexing")
@Component
public class Indexing2SamplesAction extends AbstractApiAction<Indexing2SamplesRequest, Indexing2SamplesResponse> {
    private IndexingSamplesService indexingSamplesService;

    public Indexing2SamplesAction() {
        super(Permission.COMMON);
    }

    @Override
    public Indexing2SamplesResponse process(Indexing2SamplesRequest request) {
        WebmasterHostId hostId = request.getHostId();
        int offset = request.getOffset();
        int limit = request.getLimit();

        Condition trueCondition = Condition.trueCondition();
        int count = (int)indexingSamplesService.getSamplesCount(hostId, trueCondition);
        if (count == 0 || offset >= count) {
            return new Indexing2SamplesResponse(count, Collections.emptyList());
        }

        // получим сэмплы
        List<IndexedUrlSample> rawSamples = indexingSamplesService.getSamples(
                hostId, trueCondition, IndexedUrlSamplesOrderField.LAST_ACCESS, OrderDirection.ASC, offset, limit);

        // и приведем их к нужному виду
        List<ApiIndexedPageSample> samples = rawSamples.stream()
                .map(s -> ApiIndexedPageSample.fromIndexedUrlSample(hostId, s))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        return new Indexing2SamplesResponse(count, samples);
    }

    @Required
    public void setIndexingSamplesService(IndexingSamplesService indexingSamplesService) {
        this.indexingSamplesService = indexingSamplesService;
    }
}
