package ru.yandex.webmaster3.api.indexing2.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.indexing2.data.ApiIndexedPageSample;

import java.util.List;

/**
 * @author avhaliullin
 */
public class Indexing2SamplesResponse extends ApiResponse.Success200 {
    private final int count;
    private final List<ApiIndexedPageSample> samples;

    public Indexing2SamplesResponse(int count, List<ApiIndexedPageSample> samples) {
        this.count = count;
        this.samples = samples;
    }

    @Description("общее количество доступных примеров")
    public int getCount() {
        return count;
    }

    @Description("примеры страниц")
    public List<ApiIndexedPageSample> getSamples() {
        return samples;
    }
}
