package ru.yandex.webmaster3.api.indexing2.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.codes.DownloadedHttpCodeGroup;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public enum IndexingStatusEnum {
    HTTP_2XX,
    HTTP_3XX,
    HTTP_4XX,
    HTTP_5XX,
    @Description("все остальные статусы (неправильные http-коды, ошибки соединения и т.д.)")
    OTHER,
    ;

    public static IndexingStatusEnum of(int httpCode) {
        Optional<DownloadedHttpCodeGroup> grpOpt = DownloadedHttpCodeGroup.get(httpCode);
        if (grpOpt.isPresent()) {
            switch (grpOpt.get()) {
                case DOWNLOADED_2XX:
                    return HTTP_2XX;

                case DOWNLOADED_3XX:
                    return HTTP_3XX;

                case DOWNLOADED_4XX:
                    return HTTP_4XX;

                case DOWNLOADED_5XX:
                    return HTTP_5XX;
            }
        }

        return OTHER;
    }
}
