package ru.yandex.webmaster3.api.links.action;

import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;
import ru.yandex.webmaster3.api.links.ExternalLinkSamplesLocator;

/**
 * @author avhaliullin
 */
public class ExternalLinkSamplesRequest extends AbstractApiUserVerifiedHostRequest<ExternalLinkSamplesLocator>
        implements ApiPaginationRequest {
    private int offset = 0;
    private int limit = 10;

    @Override
    public int getOffset() {
        return offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    @Override
    @MaxValue(100)
    public void setLimit(int limit) {
        this.limit = limit;
    }
}
