package ru.yandex.webmaster3.api.links.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.links.data.ApiExternalLinksIndicator;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ExternalLinksHistoryResponse extends ApiResponse.Success200 {
    private final Map<ApiExternalLinksIndicator, List<ApiHistoryPoint<Long>>> indicators;

    public ExternalLinksHistoryResponse(Map<ApiExternalLinksIndicator, List<ApiHistoryPoint<Long>>> indicators) {
        this.indicators = indicators;
    }

    @Description("Истории значений запрошенных индикаторов")
    public Map<ApiExternalLinksIndicator, List<ApiHistoryPoint<Long>>> getIndicators() {
        return indicators;
    }
}
