package ru.yandex.webmaster3.api.links.action;

import lombok.Getter;
import lombok.Setter;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiDateRangeRequest;
import ru.yandex.webmaster3.api.links.InternalLinksBrokenHistoryLocator;
import ru.yandex.webmaster3.api.links.data.ApiInternalLinksBrokenIndicator;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.host.HostDataState;

import java.util.Set;

/**
 * @author leonidrom
 */
@Getter
@Setter
public class InternalLinksBrokenHistoryRequest extends AbstractApiUserVerifiedHostRequest<InternalLinksBrokenHistoryLocator>
        implements IndexedHostRequest, ApiDateRangeRequest {
    private Set<ApiInternalLinksBrokenIndicator> indicators;
    private HostDataState hostDataState;
    private DateTime dateFrom;
    private DateTime dateTo;

    @Description("Список индикаторов для отображения")
    @RequestQueryProperty(required = true)
    public void setIndicators(Set<ApiInternalLinksBrokenIndicator> indicators) {
        this.indicators = indicators;
    }
}
