package ru.yandex.webmaster3.api.links.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.links.data.ApiInternalLinksBrokenIndicator;

import java.util.List;
import java.util.Map;

/**
 * @author leonidrom
 */
public class InternalLinksBrokenHistoryResponse extends ApiResponse.Success200 {
    private final Map<ApiInternalLinksBrokenIndicator, List<ApiHistoryPoint<Long>>> indicators;

    public InternalLinksBrokenHistoryResponse(Map<ApiInternalLinksBrokenIndicator, List<ApiHistoryPoint<Long>>> indicators) {
        this.indicators = indicators;
    }

    @Description("Истории значений запрошенных индикаторов")
    public Map<ApiInternalLinksBrokenIndicator, List<ApiHistoryPoint<Long>>> getIndicators() {
        return indicators;
    }
}
