package ru.yandex.webmaster3.api.links.action;

import lombok.Getter;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;
import ru.yandex.webmaster3.api.links.InternalLinksBrokenSamplesLocator;
import ru.yandex.webmaster3.api.links.data.ApiInternalLinksBrokenIndicator;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

import java.util.Set;

/**
 * @author leonidrom
 */
@Getter
public class InternalLinksBrokenSamplesRequest extends AbstractApiUserVerifiedHostRequest<InternalLinksBrokenSamplesLocator>
        implements ApiPaginationRequest {
    private Set<ApiInternalLinksBrokenIndicator> indicators;
    private int offset = 0;
    private int limit = 10;

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    @MaxValue(100)
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Description("Список индикаторов для отображения")
    @RequestQueryProperty
    public void setIndicators(Set<ApiInternalLinksBrokenIndicator> indicators) {
        this.indicators = indicators;
    }
}
