package ru.yandex.webmaster3.api.links.action;

import lombok.RequiredArgsConstructor;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.links.data.ApiLinkSample;

import java.util.List;

/**
 * @author leonidrom
 */
@RequiredArgsConstructor
public class InternalLinksBrokenSamplesResponse extends ApiResponse.Success200 {
    private final long count;
    private final List<ApiLinkSample> links;

    @Description("Количество доступных примеров ссылок")
    public long getCount() {
        return count;
    }

    @Description("Примеры неработающих внутренних ссылок, найденых роботами яндекса")
    public List<ApiLinkSample> getLinks() {
        return links;
    }
}
