package ru.yandex.webmaster3.api.links.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.link.LinkHistoryIndicatorType;

/**
 * @author avhaliullin
 */
public enum ApiExternalLinksIndicator {
    @Description("Общее количество известных внешних ссылок на хост")
    LINKS_TOTAL_COUNT(LinkHistoryIndicatorType.EXTERNAL_LINK_URLS_COUNT),
    ;

    private final LinkHistoryIndicatorType indicator;

    ApiExternalLinksIndicator(LinkHistoryIndicatorType indicator) {
        this.indicator = indicator;
    }

    public LinkHistoryIndicatorType getIndicator() {
        return indicator;
    }
}
