package ru.yandex.webmaster3.api.links.data;

import org.jetbrains.annotations.NotNull;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.codes.ErrorGroupEnum;

import java.util.EnumMap;
import java.util.Map;

/**
 * @author leonidrom
 */
public enum ApiInternalLinksBrokenIndicator {
    @Description("Ошибки на стороне сервера")
    SITE_ERROR(ErrorGroupEnum.SITE_ERROR),
    @Description("Запрещены к индексированию или не существуют")
    DISALLOWED_BY_USER(ErrorGroupEnum.DISALLOWED_BY_USER),
    @Description("Не поддерживаются основным индексирующим роботом Поиска")
    UNSUPPORTED_BY_ROBOT(ErrorGroupEnum.UNSUPPORTED_BY_ROBOT);

    private final ErrorGroupEnum errorGroup;

    ApiInternalLinksBrokenIndicator(ErrorGroupEnum errorGroup) {
        this.errorGroup = errorGroup;
    }

    public ErrorGroupEnum getErrorGroup() {
        return errorGroup;
    }

    private static final Map<ErrorGroupEnum, ApiInternalLinksBrokenIndicator> ERROR_GROUP_2_API_INDICATOR =
            new EnumMap<>(ErrorGroupEnum.class);

    static {
        for (var indicator : ApiInternalLinksBrokenIndicator.values()) {
            ERROR_GROUP_2_API_INDICATOR.put(indicator.errorGroup, indicator);
        }
    }

    @NotNull
    public static ApiInternalLinksBrokenIndicator fromErrorCodeGroup(ErrorGroupEnum codeGroup) {
        var indicator = ERROR_GROUP_2_API_INDICATOR.get(codeGroup);
        if (codeGroup == null) {
            throw new RuntimeException("Unexpected code group: " + codeGroup);
        }

        return indicator;
    }
}
