package ru.yandex.webmaster3.api.links.data;

import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.link.HostLinkSample;
import ru.yandex.webmaster3.core.util.TimeUtils;

/**
 * @author avhaliullin
 */
public class ApiLinkSample {
    private final String sourceUrl;
    private final String destinationUrl;
    private final LocalDate discoveryDate;
    private final LocalDate sourceLastAccessDate;
//    private final LocalDate destinationLastAccessDate;

    public ApiLinkSample(String sourceUrl, String destinationUrl, LocalDate discoveryDate,
                         LocalDate sourceLastAccessDate) {
        this.sourceUrl = sourceUrl;
        this.destinationUrl = destinationUrl;
        this.discoveryDate = discoveryDate;
        this.sourceLastAccessDate = sourceLastAccessDate;
//        this.destinationLastAccessDate = destinationLastAccessDate;
    }

    @Description("URL страницы, содержащей ссылку на сайт")
    public String getSourceUrl() {
        return sourceUrl;
    }

    @Description("URL страницы назначения (НА которую ссылка)")
    public String getDestinationUrl() {
        return destinationUrl;
    }

    @Description("Дата обнаружения ссылки")
    public LocalDate getDiscoveryDate() {
        return discoveryDate;
    }

    @Description("Дата последнего обхода страницы-источника ссылки ")
    public LocalDate getSourceLastAccessDate() {
        return sourceLastAccessDate;
    }

    public static ApiLinkSample fromHostLinkSample(HostLinkSample link) {
        var discoveryDate = link.getLinkDiscoverDate().toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toLocalDate();
        var sourceLastAccessDate = link.getSourceUrlLastAccessDate().toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toLocalDate();

        return new ApiLinkSample(
                link.getSourceUrl(),
                link.getHostUrl(),
                discoveryDate,
                sourceLastAccessDate
        );
    }

//    @Description("Дата последнего обхода страницы назначения")
//    public LocalDate getDestinationLastAccessDate() {
//        return destinationLastAccessDate;
//    }
}
