package ru.yandex.webmaster3.api.queries.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.queries.QueriesListLocator;
import ru.yandex.webmaster3.api.queries.data.ApiQueryIndicator;
import ru.yandex.webmaster3.api.queries.data.ApiQueryOrderField;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.host.HostDataState;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class ListQueriesRequest extends AbstractApiUserVerifiedHostRequest<QueriesListLocator>
        implements IndexedHostRequest {
    private HostDataState hostDataState;

    private ApiQueryOrderField orderBy;

    private Set<ApiQueryIndicator> queryIndicators;

    public Set<ApiQueryIndicator> getQueryIndicators() {
        return queryIndicators;
    }

    @RequestQueryProperty
    @Description("Индикаторы для отображения")
    public void setQueryIndicators(Set<ApiQueryIndicator> queryIndicators) {
        this.queryIndicators = queryIndicators;
    }

    public ApiQueryOrderField getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty(required = true)
    @Description("Показатель для сортировки")
    public void setOrderBy(ApiQueryOrderField orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public HostDataState getHostDataState() {
        return hostDataState;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }
}
