package ru.yandex.webmaster3.api.queries.action;

import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.queries.data.ApiQueryStats;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ListQueriesResponse extends ApiResponse.Success200 {
    private final List<ApiQueryStats> queries;
    private final LocalDate dateFrom;
    private final LocalDate dateTo;

    public ListQueriesResponse(List<ApiQueryStats> queries, LocalDate dateFrom, LocalDate dateTo) {
        this.queries = queries;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
    }

    @Description("Список популярных поисковых запросов")
    public List<ApiQueryStats> getQueries() {
        return queries;
    }

    @Description("Дата начала интервала")
    public LocalDate getDateFrom() {
        return dateFrom;
    }

    @Description("Дата конца интервала")
    public LocalDate getDateTo() {
        return dateTo;
    }
}
