package ru.yandex.webmaster3.api.queries.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;

/**
 * @author avhaliullin
 */
public enum ApiQueryIndicator {
    @Description("Количество показов")
    TOTAL_SHOWS(QueryIndicator.TOTAL_SHOWS_COUNT),
    @Description("Количество кликов")
    TOTAL_CLICKS(QueryIndicator.TOTAL_CLICKS_COUNT),
    @Description("Средняя позиция показа")
    AVG_SHOW_POSITION(QueryIndicator.AVERAGE_SHOW_POSITION),
    @Description("Средняя позиция клика")
    AVG_CLICK_POSITION(QueryIndicator.AVERAGE_CLICK_POSITION),
    ;

    private final QueryIndicator queryIndicator;

    ApiQueryIndicator(QueryIndicator queryIndicator) {
        this.queryIndicator = queryIndicator;
    }

    public QueryIndicator getCoreQueryIndicator() {
        return queryIndicator;
    }
}
