package ru.yandex.webmaster3.api.queries.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;

/**
 * @author avhaliullin
 */
public enum ApiQueryOrderField {
    @Description("Количество показов")
    TOTAL_SHOWS(QueryIndicator.TOTAL_SHOWS_COUNT),
    @Description("Количество кликов")
    TOTAL_CLICKS(QueryIndicator.TOTAL_CLICKS_COUNT),
    ;

    private final QueryIndicator queryIndicator;

    ApiQueryOrderField(QueryIndicator queryIndicator) {
        this.queryIndicator = queryIndicator;
    }

    public QueryIndicator getQueryIndicator() {
        return queryIndicator;
    }
}
