package ru.yandex.webmaster3.api.queries.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.searchquery.QueryId;

import java.util.Map;

/**
 * @author avhaliullin
 */
public class ApiQueryStats {
    private final QueryId queryId;
    private final String queryText;
    private final Map<ApiQueryIndicator, Double> indicators;

    public ApiQueryStats(QueryId queryId, String queryText, Map<ApiQueryIndicator, Double> indicators) {
        this.queryId = queryId;
        this.queryText = queryText;
        this.indicators = indicators;
    }

    @Description("id запроса")
    public QueryId getQueryId() {
        return queryId;
    }

    @Description("Текст запроса")
    public String getQueryText() {
        return queryText;
    }

    @Description("Показатели запроса (показатель может отсутствовать, если его значение не определено)")
    public Map<ApiQueryIndicator, Double> getIndicators() {
        return indicators;
    }
}
