package ru.yandex.webmaster3.api.queries2.action;

import lombok.Getter;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiDateRangeRequest;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;
import ru.yandex.webmaster3.api.queries.QueriesListLocator;
import ru.yandex.webmaster3.api.queries.data.ApiQueryIndicator;
import ru.yandex.webmaster3.api.queries.data.ApiQueryOrderField;
import ru.yandex.webmaster3.api.queries2.data.ApiDeviceTypeIndicator;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.host.HostDataState;

import java.util.Set;

/**
 * @author leonidrom
 */
@Getter
public class ListSearchQueriesRequest extends AbstractApiUserVerifiedHostRequest<QueriesListLocator>
        implements IndexedHostRequest, ApiDateRangeRequest, ApiPaginationRequest {
    // В старых версиях API не было пагинации, поэтому отдавали не все
    private static final int QUERIES_LIMIT = 500;

    private HostDataState hostDataState;
    private ApiQueryOrderField orderBy;
    private Set<ApiQueryIndicator> queryIndicators;
    private DateTime dateFrom;
    private DateTime dateTo;
    private int offset;
    private int limit = QUERIES_LIMIT;
    private ApiDeviceTypeIndicator deviceTypeIndicator = ApiDeviceTypeIndicator.ALL;

    @RequestQueryProperty
    @Description("индикаторы для отображения")
    public void setQueryIndicators(Set<ApiQueryIndicator> queryIndicators) {
        this.queryIndicators = queryIndicators;
    }

    @RequestQueryProperty(required = true)
    @Description("показатель для сортировки")
    public void setOrderBy(ApiQueryOrderField orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }

    @Override
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    @MaxValue(500)
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Description("тип устройства")
    @RequestQueryProperty
    public void setDeviceTypeIndicator(ApiDeviceTypeIndicator deviceTypeIndicator) {
        this.deviceTypeIndicator = deviceTypeIndicator;
    }
}

