package ru.yandex.webmaster3.api.queries2.action;

import lombok.RequiredArgsConstructor;
import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.queries.data.ApiQueryStats;

import java.util.List;

/**
 * @author leonidrom
 */
@RequiredArgsConstructor
public class ListSearchQueriesResponse extends ApiResponse.Success200 {
    private final int count;
    private final List<ApiQueryStats> queries;
    private final LocalDate dateFrom;
    private final LocalDate dateTo;

    @Description("Список популярных поисковых запросов")
    public List<ApiQueryStats> getQueries() {
        return queries;
    }

    @Description("Дата начала интервала")
    public LocalDate getDateFrom() {
        return dateFrom;
    }

    @Description("Дата конца интервала")
    public LocalDate getDateTo() {
        return dateTo;
    }

    @Description("Общее количество доступных запросов")
    public int getCount() {
        return count;
    }
}
