package ru.yandex.webmaster3.api.queries2.action;

import lombok.Getter;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiDateRangeRequest;
import ru.yandex.webmaster3.api.queries.data.ApiQueryIndicator;
import ru.yandex.webmaster3.api.queries2.SearchQueryLocator;
import ru.yandex.webmaster3.api.queries2.data.ApiDeviceTypeIndicator;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.host.HostDataState;

import java.util.Set;

/**
 * @author leonidrom
 */
@Getter
public class SearchQueryHistoryRequest extends AbstractApiUserVerifiedHostRequest<SearchQueryLocator>
        implements IndexedHostRequest, ApiDateRangeRequest {
    private HostDataState hostDataState;
    private Set<ApiQueryIndicator> queryIndicators;
    private DateTime dateFrom;
    private DateTime dateTo;
    private ApiDeviceTypeIndicator deviceTypeIndicator = ApiDeviceTypeIndicator.ALL;

    @RequestQueryProperty
    @Description("Индикаторы для отображения")
    public void setQueryIndicators(Set<ApiQueryIndicator> queryIndicators) {
        this.queryIndicators = queryIndicators;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }

    @Override
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    @Description("тип устройства")
    @RequestQueryProperty
    public void setDeviceTypeIndicator(ApiDeviceTypeIndicator deviceTypeIndicator) {
        this.deviceTypeIndicator = deviceTypeIndicator;
    }
}
