package ru.yandex.webmaster3.api.queries2.action;

import lombok.RequiredArgsConstructor;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.queries.data.ApiQueryIndicator;
import ru.yandex.webmaster3.core.searchquery.QueryId;

import java.util.List;
import java.util.Map;

/**
 * @author leonidrom
 */
public interface SearchQueryHistoryResponse extends ApiGetResponse {
    @RequiredArgsConstructor
    class NormalResponse extends ApiResponse.Success200 implements SearchQueryHistoryResponse {
        private final QueryId queryId;
        private final String queryText;
        private final Map<ApiQueryIndicator, List<ApiHistoryPoint<Double>>> indicators;

        @Description("id поискового запроса, для которого отдается история")
        public QueryId getQueryId() {
            return queryId;
        }

        @Description("текст поискового запроса, для которого отдается история")
        public String getQueryText() {
            return queryText;
        }

        @Description("история статистики для поискового запроса")
        public Map<ApiQueryIndicator, List<ApiHistoryPoint<Double>>> getIndicators() {
            return indicators;
        }
    }

    enum Errors implements ApiErrorCode {
        QUERY_ID_NOT_FOUND,
    }

    @Description("Невалидный id поискового запроса")
    class InvalidQueryIdResponse extends NotFound404<Errors> implements SearchQueryHistoryResponse {
        public InvalidQueryIdResponse(QueryId queryId) {
            super(Errors.QUERY_ID_NOT_FOUND, "Query id " + queryId + " not found");
        }
    }
}
