package ru.yandex.webmaster3.api.queries2.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;

/**
 * @author leonidrom
 */
public enum ApiDeviceTypeIndicator {
    @Description("Все типы устройств")
    ALL(DeviceType.ALL_DEVICES),
    @Description("Только десктоп")
    DESKTOP(DeviceType.DESKTOP),
    @Description("Мобильные и планшеты")
    MOBILE_AND_TABLET(DeviceType.MOBILE_AND_PAD),
    @Description("Только мобильные")
    MOBILE(DeviceType.MOBILE),
    @Description("Только планшеты")
    TABLET(DeviceType.PAD)
    ;

    private final DeviceType deviceType;

    ApiDeviceTypeIndicator(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public DeviceType getCoreDeviceType() {
        return deviceType;
    }
}
