package ru.yandex.webmaster3.api.searchurls.action;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.searchurls.data.ApiSearchEventSample;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.searchurl.SearchUrlSamplesService;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlEventSample;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@Category("searchurls")
@Component
public class SearchUrlEventSamplesAction extends AbstractApiAction<SearchUrlEventSamplesRequest, SearchUrlEventSamplesResponse> {
    private SearchUrlSamplesService searchUrlSamplesService;

    public SearchUrlEventSamplesAction() {
        super(Permission.COMMON);
    }

    @Override
    public SearchUrlEventSamplesResponse process(SearchUrlEventSamplesRequest request) {
        WebmasterHostId hostId = request.getHostId();
        int limit = request.getLimit();
        int offset = request.getOffset();

        Condition trueCondition = Condition.trueCondition();
        int count = (int)searchUrlSamplesService.getSearchUrlEventSamplesCount(hostId, trueCondition,trueCondition);
        if (count == 0 || offset >= count) {
            new SearchUrlEventSamplesResponse(count, Collections.emptyList());
        }

        // получим сэмплы
        List<SearchUrlEventSample> rawSamples = searchUrlSamplesService.getSearchUrlEventSamples(
                hostId, trueCondition,trueCondition, offset, limit);

        // и приведем их к нужному виду
        List<ApiSearchEventSample> samples = rawSamples.stream()
                .map(ApiSearchEventSample::fromSearchUrlEventSample)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        return new SearchUrlEventSamplesResponse(count, samples);
    }

    @Required
    public void setSearchUrlSamplesService(SearchUrlSamplesService searchUrlSamplesService) {
        this.searchUrlSamplesService = searchUrlSamplesService;
    }
}
